/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.aguacate.swagger.configuration.SwaggerConfigurationCoupling;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AguacateSwaggerServlet
extends HttpServlet {
    private static final String EXTENSION = ".yaml";
    private static final int EXTENSION_LENGTH = ".yaml".length();
    private static final long serialVersionUID = 3534985525342204442L;
    private static final Logger LOGGER = LogManager.getLogger(AguacateSwaggerServlet.class);

    protected void doGet(HttpServletRequest request, HttpServletResponse response) {
        try {
            String originalName = request.getServletPath().substring(1);
            if (originalName.indexOf(47) < 0 && originalName.endsWith(EXTENSION)) {
                String name = originalName.substring(0, originalName.length() - EXTENSION_LENGTH);
                LOGGER.trace("{} -> {}", (Object)originalName, (Object)name);
                String configuration = SwaggerConfigurationCoupling.getConfiguration(name);
                if (configuration == null) {
                    response.setStatus(404);
                } else {
                    response.setStatus(200);
                    this.writeSingleString(response, configuration);
                }
            } else {
                response.setStatus(404);
            }
        }
        catch (IOException | RuntimeException e) {
            response.setStatus(500);
            LOGGER.error("on servlet", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeSingleString(HttpServletResponse response, String configuration) throws IOException {
        response.setCharacterEncoding(StandardCharsets.UTF_8.displayName());
        response.setContentType("text/x-yaml");
        PrintWriter writer = response.getWriter();
        try {
            ((Writer)writer).write(configuration);
        }
        finally {
            try {
                ((Writer)writer).close();
            }
            catch (IOException e) {
                LOGGER.warn("on close resource", (Throwable)e);
            }
        }
    }
}

