/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.swagger.configuration.spi.impl;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import net.sf.aguacate.swagger.configuration.spi.SwaggerConfiguration;
import net.sf.aguacate.util.json.JsonCodec;
import net.sf.aguacate.util.resource.ResourceLocator;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerConfigurationImpl
implements SwaggerConfiguration {
    private static final Logger LOGGER = LogManager.getFormatterLogger(SwaggerConfigurationImpl.class);
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory());
    private static final String JS_FILENAME = "convert.js";
    private final Invocable invocable;
    private final Object compiled;
    private final ResourceLocator locator;
    private final JsonCodec codec;
    private final ResourceLocator aguacateLocator;

    public SwaggerConfigurationImpl(ResourceLocator aguacateLocator, ResourceLocator locator, JsonCodec codec) {
        this.aguacateLocator = aguacateLocator;
        this.locator = locator;
        this.codec = codec;
        ScriptEngine engine = new ScriptEngineManager().getEngineByExtension("js");
        if (engine instanceof Compilable && engine instanceof Invocable) {
            this.invocable = (Invocable)((Object)engine);
            try {
                String script = this.toString(JS_FILENAME);
                this.compiled = ((Compilable)((Object)engine)).compile(script).eval();
            }
            catch (IOException | ScriptException e) {
                throw new IllegalStateException(e);
            }
        } else {
            throw new IllegalStateException("No Compilable | Invocable");
        }
    }

    @Override
    public String getConfiguration(String name) {
        try {
            String swagger = this.loadSwagger(name);
            if (swagger == null) {
                return null;
            }
            String[] parameters = this.parameters(swagger);
            LOGGER.trace("before script");
            String result = (String)this.invocable.invokeMethod(this.compiled, "convert", swagger, parameters);
            LOGGER.trace("after script");
            return YAML_MAPPER.writeValueAsString((Object)this.codec.decode(result));
        }
        catch (IOException | NoSuchMethodException | ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    String[] parameters(String swagger) throws IOException {
        Map conf = this.codec.decode(swagger);
        List entities = (List)conf.get("entities");
        String[] params = new String[entities.size()];
        int index = 0;
        for (String name : entities) {
            String string = this.loadConfiguration(name);
            if (string == null) {
                throw new IllegalStateException(name);
            }
            params[index] = string;
            ++index;
        }
        return params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String toString(String filename) throws IOException {
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            throw new IllegalStateException("not found ".concat(filename));
        }
        try {
            String string = IOUtils.toString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("On resource close", (Throwable)e);
            }
        }
    }

    String loadSwagger(String name) throws IOException {
        String filename = name.concat(".json");
        LOGGER.debug(filename);
        return this.load0(this.locator, filename);
    }

    String loadConfiguration(String name) throws IOException {
        String filename = name.concat(".json");
        LOGGER.debug(filename);
        return this.load0(this.aguacateLocator, filename);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String load0(ResourceLocator localLocator, String filename) throws IOException {
        InputStream inputStream = localLocator.open(filename);
        if (inputStream == null) {
            return null;
        }
        try {
            String string = IOUtils.toString((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return string;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.warn("on inputStream close", (Throwable)e);
            }
        }
    }
}

