/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.scheduler.job.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.effort.EffortSchedulerCoupling;
import net.sf.aguacate.scheduler.job.Job;
import net.sf.aguacate.scheduler.job.JobLoader;
import net.sf.aguacate.scheduler.job.JobSchedule;
import net.sf.aguacate.scheduler.job.JobScheduleCron;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobLoaderImpl
implements JobLoader,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(JobLoaderImpl.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.job");
    private static final String ENVIRONMENT = "DIRECTORY_JOB";
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private final ResourceLocator locator;
    private Map<String, Job> cache = Collections.emptyMap();

    public JobLoaderImpl() {
        assert (this.cache != null && this.cache.isEmpty());
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(Job.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch((Path)DIRECTORY.toPath(), (EventHandler)this);
        }
    }

    @Override
    public void load() {
        String[] names = this.locator.list(SUFFIX);
        HashMap<String, Job> temp = new HashMap<String, Job>();
        for (String filename : names) {
            String name = this.removeSufix(filename);
            Job job = this.load0(filename);
            temp.put(name, job);
            List<JobSchedule> schedules = job.getSchedules();
            if (schedules == null || schedules.isEmpty()) continue;
            int size = schedules.size();
            block5: for (int i = 0; i < size; ++i) {
                JobSchedule schedule = schedules.get(i);
                switch (schedule.getType()) {
                    case CRON: {
                        EffortSchedulerCoupling.scheduleUnixCronExpression((String)name, (String)((JobScheduleCron)schedule).getCronExpression());
                        continue block5;
                    }
                    case AT: {
                        throw new IllegalStateException("Not implemented");
                    }
                    default: {
                        throw new IllegalArgumentException(schedule.getType().name());
                    }
                }
            }
        }
        LOGGER.trace("jobs: {}", temp);
        this.cache = temp;
    }

    @Override
    public Job get(String name) {
        return this.cache.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Job load0(String filename) {
        Job job;
        LOGGER.debug(filename);
        LOGGER2.info("Loading script: {}", (Object)filename);
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            return null;
        }
        try {
            Map<String, Object> source = this.checkSpecs(CodecCoupling.jsonCodecBridge().decodeMap((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8)));
            List scheds = (List)source.get("schedules");
            if (scheds == null || scheds.isEmpty()) {
                throw new IllegalArgumentException("No schedules");
            }
            int size = scheds.size();
            ArrayList<JobSchedule> schedules = new ArrayList<JobSchedule>(size);
            for (int i = 0; i < size; ++i) {
                JobScheduleCron jobSchedule;
                String type;
                Map current = (Map)scheds.get(i);
                switch (type = (String)current.get("type")) {
                    case "cron": {
                        jobSchedule = new JobScheduleCron((String)current.get("expression"));
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(type);
                    }
                }
                schedules.add(jobSchedule);
            }
            job = new Job((String)source.get("definition"), (Map)source.get("context"), schedules);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("on close inputstream", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("on close inputstream", (Throwable)e);
        }
        return job;
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        if (SPECS.equals(specs)) {
            return data;
        }
        throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode((Object)specs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing job: {}", (Object)deleted);
            String name = this.removeSufix(file);
            JobLoaderImpl jobLoaderImpl = this;
            synchronized (jobLoaderImpl) {
                if (this.cache.containsKey(name)) {
                    HashMap<String, Job> temp = new HashMap<String, Job>(this.cache);
                    temp.remove(name);
                    this.cache = temp;
                }
            }
            EffortSchedulerCoupling.removeSchedules((String)name);
        } else {
            LOGGER.debug("ignore deleted file: {}", (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on job: {}", (Object)updated);
            String name = this.removeSufix(file);
            EffortSchedulerCoupling.removeSchedules((String)name);
            JobLoaderImpl jobLoaderImpl = this;
            synchronized (jobLoaderImpl) {
                HashMap<String, Job> temp = new HashMap<String, Job>(this.cache);
                Job job = this.load0(file);
                temp.put(name, job);
                List<JobSchedule> schedules = job.getSchedules();
                if (schedules != null && !schedules.isEmpty()) {
                    int size = schedules.size();
                    block7: for (int i = 0; i < size; ++i) {
                        JobSchedule schedule = schedules.get(i);
                        switch (schedule.getType()) {
                            case CRON: {
                                EffortSchedulerCoupling.scheduleUnixCronExpression((String)name, (String)((JobScheduleCron)schedule).getCronExpression());
                                continue block7;
                            }
                            case AT: {
                                throw new IllegalStateException("Not implemented");
                            }
                            default: {
                                throw new IllegalArgumentException(schedule.getType().name());
                            }
                        }
                    }
                }
                this.cache = temp;
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {}", (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_JOB defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_JOB (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_JOB (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> specs = new HashMap<String, Object>();
        specs.put("kind", "job");
        specs.put("format", "1.0");
        SPECS = specs;
    }
}

