package net.sf.aguacate.effort.sync.simple;

import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

import net.sf.aguacate.definition.Definition;
import net.sf.aguacate.definition.ExecutionListener;
import net.sf.aguacate.effort.EffortManager;

public class EffortManagerSyncSimple implements EffortManager {

	private final Executor executor;

	public EffortManagerSyncSimple() {
		this(new ThreadPoolExecutor(1, 10, 10, TimeUnit.MINUTES, new ArrayBlockingQueue<>(10)));
	}

	public EffortManagerSyncSimple(Executor executor) {
		this.executor = executor;
	}

	@Override
	public void execute(Definition definition, Map<String, Object> context, ExecutionListener listener) {
		executor.execute(new EffortRunnable(definition, context, listener));
	}

}
