/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.parameter;

import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.type.Str;

public class Parameter {
    private final String[] context;
    private final String name;
    private final String aliasOf;
    private final String from;

    public Parameter(String name) {
        this((List<String>)null, name, null, null);
    }

    public Parameter(List<String> context, String name, String aliasOf, String from) {
        this(Str.toArray(context), name, aliasOf, from);
    }

    private Parameter(String[] context, String name, String aliasOf, String from) {
        this.context = context;
        this.name = name;
        this.aliasOf = aliasOf == null ? name : aliasOf;
        this.from = from;
    }

    public String getName() {
        return this.name;
    }

    public String getAliasOf() {
        return this.aliasOf;
    }

    public String getFrom() {
        return this.from;
    }

    public Map<String, Object> calculateContext(Map<String, Object> initial) {
        if (this.context.length == 0) {
            return initial;
        }
        Map ctx = initial;
        for (String current : this.context) {
            Map temp;
            ctx = temp = (Map)ctx.get(current);
        }
        return ctx;
    }
}

