/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.environment.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.environment.EnvironmentBridge;
import net.sf.aguacate.util.environment.EnvironmentCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import net.sf.aguacate.util.type.Flt;
import net.sf.aguacate.util.type.Int;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnvironmentBridgeSpi
implements EnvironmentBridge,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(EnvironmentBridgeSpi.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.environment");
    private static final String ENVIRONMENT = "DIRECTORY_ENVIRONMENT";
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private final ResourceLocator locator;
    private Map<String, Map<String, Object>> environments = Collections.emptyMap();

    public EnvironmentBridgeSpi() {
        assert (this.environments != null && this.environments.isEmpty());
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(EnvironmentCoupling.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
    }

    @Override
    public Map<String, Object> get(String name) {
        return this.getOrLoad(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> getOrLoad(String name) {
        Map<String, Object> instance = this.environments.get(name);
        if (instance == null) {
            EnvironmentBridgeSpi environmentBridgeSpi = this;
            synchronized (environmentBridgeSpi) {
                instance = this.environments.get(name);
                if (instance == null) {
                    HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>(this.environments);
                    instance = this.load0(name.concat(SUFFIX));
                    temp.put(name, instance);
                    this.environments = temp;
                }
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<String, Object> load0(String filename) {
        Map<String, Object> map;
        LOGGER.debug(filename);
        LOGGER2.info("Loading script: {}", (Object)filename);
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            throw new IllegalArgumentException(filename);
        }
        try {
            map = this.parse((List)this.checkSpecs(CodecCoupling.jsonCodecBridge().decodeMap(new InputStreamReader(inputStream, StandardCharsets.UTF_8))).get("variables"));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("On closing resource", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(filename, e);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("On closing resource", (Throwable)e);
        }
        return map;
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        if (SPECS.equals(specs)) {
            return data;
        }
        throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode(specs)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing script definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            EnvironmentBridgeSpi environmentBridgeSpi = this;
            synchronized (environmentBridgeSpi) {
                if (this.environments.containsKey(name)) {
                    HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>(this.environments);
                    temp.remove(name);
                    this.environments = temp;
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {}", (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on script: {}", (Object)updated);
            String name = this.removeSufix(file);
            EnvironmentBridgeSpi environmentBridgeSpi = this;
            synchronized (environmentBridgeSpi) {
                if (this.environments.containsKey(name)) {
                    HashMap<String, Map<String, Object>> temp = new HashMap<String, Map<String, Object>>(this.environments);
                    temp.put(name, this.load0(file));
                    this.environments = temp;
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {}", (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    Map<String, Object> parse(List<Map<String, Object>> data) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        for (Map<String, Object> current : data) {
            Object value;
            String type = (String)current.get("type");
            Object val = current.get("value");
            switch (type) {
                case "STRING": {
                    value = val;
                    break;
                }
                case "INTEGER": {
                    value = Int.parse(val);
                    break;
                }
                case "FLOAT": {
                    value = Flt.parse(val);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(type);
                }
            }
            map.put((String)current.get("name"), value);
        }
        return map;
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_ENVIRONMENT defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_ENVIRONMENT (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_ENVIRONMENT (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("kind", "environment");
        spec.put("format", "1.0");
        SPECS = spec;
    }
}

