/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.dynamic.bridge.spi;

import java.io.Reader;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import net.sf.aguacate.util.dynamic.bridge.DynamicFactory;
import net.sf.aguacate.util.dynamic.bridge.spi.DynamicScript;

public class DynamicFactoryScript
implements DynamicFactory {
    private final ScriptEngine engine;
    private final Compilable compilable;
    private final Invocable invocable;

    public DynamicFactoryScript(ScriptEngine engine) {
        this.engine = engine;
        if (!(engine instanceof Compilable)) {
            throw new IllegalStateException("No Compilable instance ".concat(engine.getClass().getName()));
        }
        this.compilable = (Compilable)((Object)engine);
        if (!(engine instanceof Invocable)) {
            throw new IllegalStateException("No Invocable instance ".concat(engine.getClass().getName()));
        }
        this.invocable = (Invocable)((Object)engine);
    }

    @Override
    public DynamicScript createFrom(Reader reader) {
        try {
            return this.create(this.compilable.compile(reader));
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public DynamicScript createString(String source) {
        try {
            return this.create(this.compilable.compile(source));
        }
        catch (ScriptException e) {
            throw new IllegalStateException(e);
        }
    }

    DynamicScript create(CompiledScript compiled) {
        return new DynamicScript(this.engine, this.invocable, compiled);
    }

    public ScriptEngine getEngine() {
        return this.engine;
    }
}

