/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.util.codec.bridge.spi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.util.codec.bridge.CodecBridge;

public class CodecBridgeObjectMapperYaml
implements CodecBridge {
    private static final String MIMETYPE = "text/x-yaml";
    private final ObjectMapper mapper = new ObjectMapper((JsonFactory)new YAMLFactory()).configure(JsonGenerator.Feature.AUTO_CLOSE_TARGET, false);

    @Override
    public boolean support(String mimetype) {
        return MIMETYPE.equals(mimetype);
    }

    @Override
    public String mimetype() {
        return MIMETYPE;
    }

    @Override
    public Map<String, Object> decodeMap(Reader reader) throws IOException {
        return (Map)this.mapper.readValue(reader, Map.class);
    }

    @Override
    public Map<String, Object> decodeMap(String json) throws IOException {
        return (Map)this.mapper.readValue(json, Map.class);
    }

    @Override
    public List<Object> decodeList(Reader reader) throws IOException {
        return (List)this.mapper.readValue(reader, List.class);
    }

    @Override
    public List<Object> decodeList(String json) throws IOException {
        return (List)this.mapper.readValue(json, List.class);
    }

    @Override
    public Object decode(Reader reader) throws IOException {
        return this.mapper.readValue(reader, Object.class);
    }

    @Override
    public Object decode(String json) throws IOException {
        return this.mapper.readValue(json, Object.class);
    }

    @Override
    public String encode(Object object) {
        try {
            return this.mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void encode(Writer writer, Object object) throws IOException {
        try {
            this.mapper.writeValue(writer, object);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException(e);
        }
    }
}

