/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.script.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.aguacate.script.DynamicCache;
import net.sf.aguacate.util.dynamic.bridge.Dynamic;
import net.sf.aguacate.util.dynamic.bridge.DynamicFactoryCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DynamicCacheSpi
implements DynamicCache,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(DynamicCacheSpi.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.script");
    private static final String ENVIRONMENT = "DIRECTORY_SCRIPT";
    private static final File DIRECTORY;
    private static final String EXTENSION = "js";
    private static final String SUFFIX = ".js";
    private static final int SUFFIX_LENGTH = 3;
    private final ResourceLocator locator;
    private Map<String, Dynamic> cache = Collections.emptyMap();

    public DynamicCacheSpi() {
        assert (this.cache != null && this.cache.isEmpty());
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(DynamicCache.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dynamic get(String scriptName) {
        Dynamic dynamic = this.cache.get(scriptName);
        if (dynamic == null) {
            DynamicCacheSpi dynamicCacheSpi = this;
            synchronized (dynamicCacheSpi) {
                dynamic = this.cache.get(scriptName);
                if (dynamic == null) {
                    HashMap<String, Dynamic> temp = new HashMap<String, Dynamic>(this.cache);
                    dynamic = this.load0(scriptName.concat(SUFFIX));
                    temp.put(scriptName, dynamic);
                    this.cache = temp;
                }
            }
        }
        return dynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Dynamic load0(String filename) {
        Dynamic dynamic;
        LOGGER.debug(filename);
        LOGGER2.info("Loading script: {}", (Object)filename);
        InputStream inputStream = this.locator.open(filename);
        if (inputStream == null) {
            throw new IllegalArgumentException(filename);
        }
        try {
            dynamic = DynamicFactoryCoupling.getByExtension(EXTENSION).createFrom(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (IOException e) {
                    LOGGER.warn("On closing resource", (Throwable)e);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException(filename, e);
            }
        }
        try {
            inputStream.close();
        }
        catch (IOException e) {
            LOGGER.warn("On closing resource", (Throwable)e);
        }
        return dynamic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing script definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            DynamicCacheSpi dynamicCacheSpi = this;
            synchronized (dynamicCacheSpi) {
                if (this.cache.containsKey(name)) {
                    HashMap<String, Dynamic> temp = new HashMap<String, Dynamic>(this.cache);
                    temp.remove(name);
                    this.cache = temp;
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {}", (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on script: {}", (Object)updated);
            String name = this.removeSufix(file);
            DynamicCacheSpi dynamicCacheSpi = this;
            synchronized (dynamicCacheSpi) {
                if (this.cache.containsKey(name)) {
                    HashMap<String, Dynamic> temp = new HashMap<String, Dynamic>(this.cache);
                    temp.put(name, this.load0(file));
                    this.cache = temp;
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {}", (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 3);
    }

    static {
        assert (SUFFIX.equals(SUFFIX));
        assert (3 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No DIRECTORY_SCRIPT defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using DIRECTORY_SCRIPT (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using DIRECTORY_SCRIPT (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
    }
}

