/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.scheduler;

import java.util.ArrayList;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import net.sf.aguacate.scheduler.InternalTask;

public class InternalSchedulerCoupling {
    private static final Timer TIMER = new Timer();
    private static final ExecutorService EXECUTOR;
    private static final List<InternalTask> TASKS;

    public static void start() {
        int size = TASKS.size();
        for (int i = 0; i < size; ++i) {
            final InternalTask task = TASKS.get(i);
            TIMER.scheduleAtFixedRate(new TimerTask(){
                private final Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        task.execute();
                    }
                };

                @Override
                public void run() {
                    EXECUTOR.execute(this.runnable);
                }
            }, 0L, task.getPeriod());
        }
    }

    public static void stop() {
        TIMER.cancel();
        if (EXECUTOR != null) {
            EXECUTOR.shutdown();
        }
    }

    static {
        ArrayList<InternalTask> tasks = new ArrayList<InternalTask>();
        for (InternalTask instance : ServiceLoader.load(InternalTask.class)) {
            tasks.add(instance);
        }
        TASKS = tasks;
        int size = tasks.size();
        EXECUTOR = size > 0 ? new ThreadPoolExecutor(1, 10, 5L, TimeUnit.MINUTES, new ArrayBlockingQueue<Runnable>(10)) : null;
    }
}

