/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;
import org.apache.commons.text.StringSubstitutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionStringSubstitutor
extends AbstractFunction {
    private static final Logger LOGGER = LogManager.getLogger(FunctionStringSubstitutor.class);
    private final String message;
    private final Parameter parameter;
    private final Parameter[] parameters;
    private final String[] outputContext;
    private final String outputName;

    public FunctionStringSubstitutor(Collection<String> methods, String name, String message, Parameter parameter, List<Parameter> optionals, Collection<String> outputContext, String outputName) {
        super(methods, name);
        this.message = message;
        this.parameter = parameter;
        this.parameters = Prm.toArray(optionals);
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        String source = (String)this.parameter.calculateContext(context).get(this.parameter.getName());
        LinkedHashMap<String, Object> valueMap = new LinkedHashMap<String, Object>();
        for (Parameter p : this.parameters) {
            valueMap.put(p.getAliasOf(), p.calculateContext(context).get(p.getName()));
        }
        LOGGER.trace("{},{}", (Object)source, valueMap);
        StringSubstitutor substitutor = new StringSubstitutor(valueMap);
        substitutor.setEnableUndefinedVariableException(true);
        substitutor.setEnableSubstitutionInVariables(false);
        try {
            String result = substitutor.replace(source);
            if (result == null) {
                this.logFailure(this.message);
                return FAILURE;
            }
            this.logSuccess(this.message);
            return new FunctionEvalResult(true, (Object)result);
        }
        catch (IllegalArgumentException e) {
            this.logFailure(this.message);
            return new FunctionEvalResult(false, e.getMessage(), null);
        }
    }

    @Override
    public String[] getOutputContext() {
        return this.outputContext;
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }
}

