/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction1;
import net.sf.aguacate.util.parameter.Parameter;

public class FunctionNotZero
extends AbstractFunction1 {
    public FunctionNotZero(Collection<String> methods, String name, String message, Parameter parameter) {
        super(methods, name, message, parameter);
    }

    @Override
    protected FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value) {
        Class<?> klass = value.getClass();
        if (klass == BigInteger.class) {
            if (BigInteger.ZERO.equals(value)) {
                this.logFailure(msg);
                return new FunctionEvalResult("Zero", null);
            }
            this.logSuccess(msg);
            return new FunctionEvalResult(null, null);
        }
        if (Long.class == klass) {
            if (Long.valueOf(0L).equals(value)) {
                this.logFailure(msg);
                return new FunctionEvalResult("Zero", null);
            }
            this.logSuccess(msg);
            return new FunctionEvalResult(null, null);
        }
        if (klass == BigDecimal.class) {
            BigDecimal val = (BigDecimal)value;
            BigDecimal zero = BigDecimal.ZERO.setScale(val.scale());
            if (zero.equals(val)) {
                this.logFailure(msg);
                return new FunctionEvalResult("Zero", null);
            }
            this.logSuccess(msg);
            return new FunctionEvalResult(null, null);
        }
        this.logFailure(msg);
        return new FunctionEvalResult("Not implemented", null);
    }
}

