/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionCreateContext
extends AbstractFunction {
    private final String[] outputContext;
    private final String outputName;
    private final Parameter[] parameters;

    public FunctionCreateContext(Collection<String> methods, String name, Collection<Parameter> parameters, List<String> outputContext, String outputName) {
        super(methods, name);
        this.parameters = parameters.toArray(new Parameter[parameters.size()]);
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        LinkedHashMap<String, Object> ctx = new LinkedHashMap<String, Object>();
        for (Parameter parameter : this.parameters) {
            Map<String, Object> temp = parameter.calculateContext(context);
            String name = parameter.getName();
            ctx.put(name, temp.get(name));
        }
        return new FunctionEvalResult(true, ctx);
    }

    @Override
    public String[] getOutputContext() {
        return this.outputContext;
    }

    @Override
    public String getOutputName() {
        return this.outputName;
    }
}

