/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.check.Check;
import net.sf.aguacate.check.CheckCoupling;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionConditional
extends AbstractFunction {
    private static final Logger LOGGER = LogManager.getLogger(FunctionConditional.class);
    private static final FunctionEvalResult DEFAULT = new FunctionEvalResult(null, null);
    private final Function[] functions;
    private final String checkName;
    private final Check check;
    private final Parameter parameter;

    public FunctionConditional(Collection<String> methods, String name, String message, Parameter parameter, List<Function> list, String check) {
        super(methods, name);
        this.functions = list.toArray(new Function[list.size()]);
        this.checkName = check;
        this.check = CheckCoupling.get(check);
        this.parameter = parameter;
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        LOGGER.debug(this.checkName);
        if (this.check.test(this.parameter.calculateContext(context).get(this.parameter.getName()))) {
            LOGGER.trace("{}: true", (Object)this.checkName);
            for (Function function : this.functions) {
                String name = function.getName();
                LOGGER.trace("trying to execute {} with: {}", (Object)name, context);
                FunctionEvalResult result = function.evaluate(functionContext, context);
                if (result.isSuccess()) {
                    LOGGER.debug("succesful execution of {}", (Object)name);
                    String outputName = function.getOutputName();
                    if (outputName != null) {
                        String[] outputContext = function.getOutputContext();
                        if (outputContext != null && outputContext.length > 0) {
                            Map ctx = context;
                            for (String ctxName : outputContext) {
                                Map temp;
                                ctx = temp = (Map)ctx.get(ctxName);
                            }
                            LOGGER.trace("working ctx: {}", ctx);
                            ctx.put((String)outputName, (Object)result.getData());
                        } else {
                            context.put((String)outputName, (Object)result.getData());
                        }
                    }
                } else {
                    return result;
                }
                LOGGER.trace("in subcontext: {}", context);
            }
        }
        return DEFAULT;
    }
}

