/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionArrayIterator
extends AbstractFunction {
    private static final Logger LOGGER = LogManager.getLogger(FunctionArrayIterator.class);
    private String message;
    private Parameter parameter;
    private final String[] outputContext;
    private final String outputName;
    private final Function[] functions;

    public FunctionArrayIterator(Collection<String> methods, String name, String message, Parameter parameter, List<String> outputContext, String outputName, List<Function> list) {
        super(methods, name);
        this.message = message;
        this.parameter = parameter;
        this.outputContext = Str.toArray(outputContext);
        this.outputName = outputName;
        this.functions = list.toArray(new Function[list.size()]);
    }

    @Override
    public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
        Map<String, Object> working = this.calculateOutputContext(this.outputContext, context);
        if (working.containsKey(this.outputName)) {
            return new FunctionEvalResult(false, "Already defined: " + this.outputName, null);
        }
        List list = (List)working.get(this.parameter.getName());
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map subcontext = (Map)list.get(i);
            working.put(this.outputName, subcontext);
            LOGGER.trace("before context: {}", context);
            for (Function function : this.functions) {
                FunctionEvalResult result = function.evaluate(functionContext, context);
                if (result.isSuccess()) {
                    String outputName = function.getOutputName();
                    if (outputName != null) {
                        this.calculateOutputContext(function.getOutputContext(), context).put(outputName, result.getData());
                    }
                } else {
                    this.logFailure(this.message);
                    return result;
                }
                LOGGER.trace("in subcontext: {}", context);
            }
            working.remove(this.outputName);
            LOGGER.trace("after subcontext: {}", context);
        }
        this.logSuccess(this.message);
        return SUCCESS;
    }

    Map<String, Object> calculateOutputContext(String[] names, Map<String, Object> initial) {
        if (names == null || names.length == 0) {
            return initial;
        }
        Map ctx = initial;
        for (String name : names) {
            Map temp1;
            ctx = temp1 = (Map)ctx.get(name);
        }
        return ctx;
    }
}

