/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.function.spi;

import java.util.Collection;
import net.sf.aguacate.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractFunction
implements Function {
    private static final Logger MESSAGE_LOGGER = LogManager.getLogger((String)"aguacate.function");
    private final Collection<String> methods;
    private final String name;

    public AbstractFunction(Collection<String> methods, String name) {
        this.methods = methods;
        this.name = name;
    }

    @Override
    public boolean validFor(String method) {
        return this.methods.contains(method);
    }

    @Override
    public String getName() {
        return this.name;
    }

    protected void logFailure(String msg) {
        MESSAGE_LOGGER.warn("{}({}): failure", (Object)msg, (Object)this.getName());
    }

    protected void logSuccess(String msg) {
        MESSAGE_LOGGER.info("{}({}): success", (Object)msg, (Object)this.getName());
    }
}

