/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.FieldTimeUtil;
import net.sf.aguacate.validator.ValidationConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldTimeWithZone
extends Field {
    private static final Logger LOGGER = LogManager.getLogger(FieldTimeWithZone.class);
    private final Format format;
    private final String minValue;
    private final String maxValue;

    public FieldTimeWithZone(String name, String type, boolean optional, Format format, String minValue, String maxValue) {
        super(name, type, optional);
        this.format = format;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public Format getFormat() {
        return this.format;
    }

    public String getMinValue() {
        return this.minValue;
    }

    public String getMaxValue() {
        return this.maxValue;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        if (value.getClass() == String.class) {
            try {
                String string = (String)value;
                Date date = (Date)this.format.parseObject(string);
                if (date == null) {
                    return new ValidationConversionResult("Invalid format");
                }
                int ndx = FieldTimeUtil.timeZone(string);
                String tz = string.substring(ndx);
                String min = this.minValue.concat(tz);
                String max = this.maxValue.concat(tz);
                LOGGER.trace("{} & {} & {}", (Object)min, (Object)string, (Object)max);
                return FieldTimeUtil.validate((Date)this.format.parseObject(min), date, (Date)this.format.parseObject(max));
            }
            catch (ParseException e) {
                return new ValidationConversionResult("Invalid format");
            }
        }
        return new ValidationConversionResult("Invalid value");
    }
}

