/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldStructureArray
extends Field {
    private final Field[] fields;

    public FieldStructureArray(String name, boolean optional, Map<String, Field> fields) {
        this(name, optional, fields.values());
    }

    public FieldStructureArray(String name, boolean optional, Collection<Field> fields) {
        this(name, optional, fields.toArray(new Field[fields.size()]));
    }

    public FieldStructureArray(String name, boolean optional, Field[] fields) {
        super(name, "STRUCTURE_ARRAY", optional);
        this.fields = fields;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        List list = (List)value;
        ArrayList r = new ArrayList();
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            Map data = (Map)list.get(i);
            HashMap<String, Object> map = new HashMap<String, Object>();
            for (Field field : this.fields) {
                ValidationConversionResult result;
                String fieldName = field.getName();
                Object obj = data.get(fieldName);
                if (field.isOptional()) {
                    if (obj == null) {
                        map.put(fieldName, null);
                        continue;
                    }
                    result = field.validateAndConvert(obj);
                    if (result.isSuccess()) {
                        map.put(fieldName, result.getValue());
                        continue;
                    }
                    return result;
                }
                result = field.validateAndConvert(obj);
                if (result.isSuccess()) {
                    map.put(fieldName, result.getValue());
                    continue;
                }
                return result;
            }
            r.add(map);
        }
        return new ValidationConversionResult(r);
    }
}

