/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldStructure
extends Field {
    private final Field[] fields;

    public FieldStructure(String name, boolean optional, Map<String, Field> fields) {
        this(name, optional, fields.values());
    }

    public FieldStructure(String name, boolean optional, Collection<Field> fields) {
        this(name, optional, fields.toArray(new Field[fields.size()]));
    }

    public FieldStructure(String name, boolean optional, Field[] fields) {
        super(name, "STRUCTURE_ARRAY", optional);
        this.fields = fields;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        Map data = (Map)value;
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Field field : this.fields) {
            ValidationConversionResult result;
            String fieldName = field.getName();
            Object obj = data.get(fieldName);
            if (field.isOptional()) {
                if (obj == null) {
                    map.put(fieldName, null);
                    continue;
                }
                result = field.validateAndConvert(obj);
                if (result.isSuccess()) {
                    map.put(fieldName, result.getValue());
                    continue;
                }
                return result;
            }
            result = field.validateAndConvert(obj);
            if (result.isSuccess()) {
                map.put(fieldName, result.getValue());
                continue;
            }
            return result;
        }
        return new ValidationConversionResult(map);
    }
}

