/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import net.sf.aguacate.field.Field;
import net.sf.aguacate.regex.Regex;
import net.sf.aguacate.regex.RegexCouplig;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldString
extends Field {
    private final int minLenth;
    private final int maxLength;
    private final Regex regex;

    public FieldString(String name, boolean optional, int minLenth, int maxLength, String regex) {
        super(name, "STRING", optional);
        this.minLenth = minLenth;
        this.maxLength = maxLength;
        this.regex = RegexCouplig.build(regex);
    }

    public int getMinLenth() {
        return this.minLenth;
    }

    public int getMaxLength() {
        return this.maxLength;
    }

    public Regex getRegex() {
        return this.regex;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        if (value.getClass() == String.class) {
            String val = (String)value;
            int length = val.length();
            if (length < this.minLenth) {
                return new ValidationConversionResult("Invalid minimum length");
            }
            if (length > this.maxLength) {
                return new ValidationConversionResult("Invalid maximum length");
            }
            if (this.regex.matches(val)) {
                return new ValidationConversionResult(value);
            }
            return new ValidationConversionResult("No match pattern");
        }
        return new ValidationConversionResult("Invalid value");
    }
}

