/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.math.BigDecimal;
import net.sf.aguacate.field.FieldNumber;
import net.sf.aguacate.util.type.Flt;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldFloat
extends FieldNumber {
    private final BigDecimal minValue;
    private final BigDecimal maxValue;

    public FieldFloat(String name, boolean optional, String minValue, String maxValue) {
        super(name, "FLOAT", optional);
        this.minValue = new BigDecimal(minValue);
        this.maxValue = new BigDecimal(maxValue);
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        if (value.getClass() == String.class) {
            try {
                return this.validate(this.minValue, Flt.parse(value), this.maxValue);
            }
            catch (NumberFormatException e) {
                return new ValidationConversionResult("Invalid format");
            }
        }
        return new ValidationConversionResult("Invalid value");
    }
}

