/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.text.Format;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.FieldTimeUtil;
import net.sf.aguacate.validator.ValidationConversionResult;
import org.apache.commons.lang3.time.FastDateFormat;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FieldDynamicDate
extends Field {
    private static final Logger LOGGER = LogManager.getLogger(FieldDynamicDate.class);
    private final Format format;
    private final String minVal;
    private final String maxVal;

    public FieldDynamicDate(String name, boolean optional, Format format, String minVal, String maxVal) {
        super(name, "DYNAMIC_DATE", optional);
        this.format = format;
        this.minVal = minVal;
        this.maxVal = maxVal;
    }

    public Date getMinValue(Calendar calendar) {
        if ("TODAY".equalsIgnoreCase(this.minVal)) {
            calendar.set(11, 0);
            calendar.set(12, 0);
            calendar.set(13, 0);
            calendar.set(14, 0);
            return calendar.getTime();
        }
        throw new IllegalStateException(this.minVal);
    }

    public Date getMaxValue() {
        if ("FUTURE".equalsIgnoreCase(this.maxVal)) {
            return null;
        }
        throw new IllegalStateException(this.maxVal);
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        LOGGER.trace(value);
        if (String.class == value.getClass()) {
            String val = (String)value;
            try {
                Date date = (Date)this.format.parseObject(val);
                if (date == null) {
                    return new ValidationConversionResult("Invalid format");
                }
                LOGGER.trace((Object)date);
                int ndx = FieldTimeUtil.timeZone(val);
                date = FastDateFormat.getInstance((String)"yyyy-MM-dd").parse(val.substring(0, ndx));
                Calendar calendar = Calendar.getInstance();
                int minutes = FieldTimeUtil.calculateDiff(calendar, val);
                calendar.add(12, minutes);
                int hr = calendar.get(11);
                int mins = calendar.get(12);
                int secs = calendar.get(13);
                int mills = calendar.get(14);
                Date min = this.getMinValue(calendar);
                calendar.setTime(date);
                calendar.set(11, hr);
                calendar.set(12, mins);
                calendar.set(13, secs);
                calendar.set(14, mills);
                date = calendar.getTime();
                LOGGER.debug("{} & {}", (Object)min, (Object)date);
                if (min.compareTo(date) <= 0) {
                    Date max = this.getMaxValue();
                    LOGGER.debug("{} & {}", (Object)date, (Object)max);
                    if (max == null || date.compareTo(max) < 0) {
                        return new ValidationConversionResult(date);
                    }
                    return new ValidationConversionResult("Invalid maximum value");
                }
                return new ValidationConversionResult("Invalid minimum value");
            }
            catch (ParseException e) {
                return new ValidationConversionResult("Invalid format");
            }
        }
        return new ValidationConversionResult("Invalid value");
    }
}

