/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.FieldTimeUtil;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldDate
extends Field {
    private final Format format;
    private final Date minValue;
    private final Date maxValue;

    public FieldDate(String name, boolean optional, Format format, String minValue, String maxValue) {
        super(name, "DATE", optional);
        this.format = format;
        try {
            this.minValue = (Date)format.parseObject(minValue);
            this.maxValue = (Date)format.parseObject(maxValue);
        }
        catch (ParseException e) {
            throw new IllegalStateException(e);
        }
    }

    public Format getFormat() {
        return this.format;
    }

    public Date getMinValue() {
        return this.minValue;
    }

    public Date getMaxValue() {
        return this.maxValue;
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        if (value.getClass() == String.class) {
            try {
                String string = (String)value;
                Date date = (Date)this.format.parseObject(string);
                if (date == null) {
                    return new ValidationConversionResult("Invalid format");
                }
                return FieldTimeUtil.validate(this.minValue, date, this.maxValue);
            }
            catch (ParseException e) {
                return new ValidationConversionResult("Invalid format");
            }
        }
        return new ValidationConversionResult("Invalid value");
    }
}

