/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.field;

import net.sf.aguacate.field.Field;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldBoolean
extends Field {
    public FieldBoolean(String name, boolean optional) {
        super(name, "BOOLEAN", optional);
    }

    @Override
    public ValidationConversionResult validateAndConvert(Object value) {
        Class<?> klass = value.getClass();
        if (klass == Boolean.class) {
            return new ValidationConversionResult(value);
        }
        if (klass == String.class) {
            String val = ((String)value).toLowerCase();
            if ("true".equals(val)) {
                return new ValidationConversionResult(Boolean.TRUE);
            }
            if ("false".equals(val)) {
                return new ValidationConversionResult(Boolean.FALSE);
            }
            return new ValidationConversionResult("Invalid boolean value");
        }
        return new ValidationConversionResult("Invalid boolean value");
    }
}

