/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.definition.compiler.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlBeginTransaction;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlDelete;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlEndTransaction;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlInsert;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlInsertWithId;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlSelectMultipleRow;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlSelectSingle;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlSelectSingleRow;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticDelete;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticInsert;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticInsertWithId;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticSelectList;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticSelectMultipleRow;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticSelectSingle;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticSelectSingleRow;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlStaticUpdate;
import net.sf.aguacate.context.spi.sql.impl.SentenceSqlUpdate;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.spi.impl.FunctionArrayIterator;
import net.sf.aguacate.function.spi.impl.FunctionConditional;
import net.sf.aguacate.function.spi.impl.FunctionCreateContext;
import net.sf.aguacate.function.spi.impl.FunctionDivide;
import net.sf.aguacate.function.spi.impl.FunctionLiteralFloat;
import net.sf.aguacate.function.spi.impl.FunctionLiteralInteger;
import net.sf.aguacate.function.spi.impl.FunctionLiteralString;
import net.sf.aguacate.function.spi.impl.FunctionMultiply;
import net.sf.aguacate.function.spi.impl.FunctionRename;
import net.sf.aguacate.function.spi.impl.FunctionSubstract;
import net.sf.aguacate.function.spi.impl.FunctionSum;
import net.sf.aguacate.util.parameter.Prm;
import net.sf.aguacate.util.type.Str;

public class ParserProcessor {
    public List<Function> parse(List<Map<String, Object>> source) {
        if (source == null) {
            return Collections.emptyList();
        }
        ArrayList<Function> result = new ArrayList<Function>();
        int size = source.size();
        for (int i = 0; i < size; ++i) {
            result.add(this.toSentence(source.get(i)));
        }
        return result;
    }

    Function toSentence(Map<String, Object> source) {
        Function function;
        String type = (String)source.get("type");
        String name = (String)source.get("name");
        String message = (String)source.get("message");
        String table = (String)source.get("table");
        List required = (List)source.get("required");
        List optional = (List)source.get("optional");
        List methods = (List)source.get("methods");
        switch (type) {
            case "DELETE": {
                function = new SentenceSqlDelete(name, message, table, methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "INSERT": {
                function = new SentenceSqlInsert(name, message, table, methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "INSERT_RECOVER_ID": {
                function = new SentenceSqlInsertWithId(name, message, table, methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"), (String)source.get("column"));
                break;
            }
            case "UPDATE": {
                function = new SentenceSqlUpdate(name, message, table, methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "SELECT_SINGLE_ROW": {
                function = new SentenceSqlSelectSingleRow(name, message, table, methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SELECT_SINGLE": {
                function = new SentenceSqlSelectSingle(name, message, table, methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SELECT_MULTIPLE_ROW": {
                function = new SentenceSqlSelectMultipleRow(name, message, table, methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "STRUCTURE_ARRAY_ITERATOR": {
                List<Function> subsentences = this.parse((List)source.get("sentences"));
                function = new FunctionArrayIterator(Collections.emptyList(), name, message, Prm.toParameter(required.get(0)), Str.toList(source.get("outputContext")), (String)source.get("outputName"), subsentences);
                break;
            }
            case "CONDITIONAL": {
                List<Function> subsentences = this.parse((List)source.get("sentences"));
                function = new FunctionConditional(Collections.emptyList(), name, message, Prm.toParameter(required.get(0)), subsentences, (String)source.get("test"));
                break;
            }
            case "SQL_INSERT": {
                function = new SentenceSqlStaticInsert(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "SQL_INSERT_RECOVER_ID": {
                function = new SentenceSqlStaticInsertWithId(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional), (String)source.get("column"));
                break;
            }
            case "SQL_UPDATE": {
                function = new SentenceSqlStaticUpdate(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "SQL_DELETE": {
                function = new SentenceSqlStaticDelete(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional));
                break;
            }
            case "SQL_SELECT_SINGLE": {
                function = new SentenceSqlStaticSelectSingle(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SQL_SELECT_LIST": {
                function = new SentenceSqlStaticSelectList(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SQL_SELECT_MULTIPLE_ROW": {
                function = new SentenceSqlStaticSelectMultipleRow(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SQL_SELECT_SINGLE_ROW": {
                function = new SentenceSqlStaticSelectSingleRow(name, message, (String)source.get("sql"), methods, Prm.toList(required), Prm.toList(optional), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "LITERAL_STRING": {
                function = new FunctionLiteralString(methods, name, message, Str.toList(source.get("outputContext")), (String)source.get("outputName"), source.get("value"));
                break;
            }
            case "LITERAL_INTEGER": {
                function = new FunctionLiteralInteger(methods, name, message, Str.toList(source.get("outputContext")), (String)source.get("outputName"), source.get("value"));
                break;
            }
            case "LITERAL_FLOAT": {
                function = new FunctionLiteralFloat(methods, name, message, Str.toList(source.get("outputContext")), (String)source.get("outputName"), source.get("value"));
                break;
            }
            case "BEGIN_TRANSACTION": {
                function = new SentenceSqlBeginTransaction(name, message, methods);
                break;
            }
            case "END_TRANSACTION": {
                function = new SentenceSqlEndTransaction(name, message, methods);
                break;
            }
            case "CONTEXT": {
                function = new FunctionCreateContext(methods, name, Prm.toList(required), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "REN": {
                if (required.size() == 1) {
                    function = new FunctionRename(methods, name, message, Prm.toParameter(required.get(0)), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                    break;
                }
                throw new IllegalArgumentException("The number or parameters for function type '" + type + "'(" + name + ") must be 1");
            }
            case "SUM": {
                function = new FunctionSum(methods, name, message, Prm.toParameter(required.get(0)), Prm.toParameter(required.get(1)), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "SUBSTRACT": {
                function = new FunctionSubstract(methods, name, message, Prm.toParameter(required.get(0)), Prm.toParameter(required.get(1)), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "MULTIPLY": {
                function = new FunctionMultiply(methods, name, message, Prm.toParameter(required.get(0)), Prm.toParameter(required.get(1)), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            case "DIVIDE": {
                function = new FunctionDivide(methods, name, message, Prm.toParameter(required.get(0)), Prm.toParameter(required.get(1)), Str.toList(source.get("outputContext")), (String)source.get("outputName"));
                break;
            }
            default: {
                throw new IllegalArgumentException(type);
            }
        }
        return function;
    }
}

