/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.definition;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.util.config.database.DatabaseBridge;
import net.sf.aguacate.util.config.database.DatabaseInterface;
import net.sf.aguacate.util.environment.EnvironmentCoupling;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FunctionContextDefinition
implements FunctionContext {
    private static final Logger LOGGER = LogManager.getLogger(FunctionContextDefinition.class);
    private final DatabaseBridge databaseBridge;
    private Connection connection;

    public FunctionContextDefinition(DatabaseBridge databaseBridge) {
        this.databaseBridge = databaseBridge;
    }

    @Override
    public DatabaseInterface databaseInterface() {
        return this.databaseBridge.getDatabaseInterface();
    }

    @Override
    public String getMethod() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Connection acquireConnection() throws SQLException {
        if (this.connection == null) {
            this.connection = this.databaseBridge.getDataSource().getConnection();
        }
        return this.connection;
    }

    @Override
    public Map<String, Object> get(String name) {
        return EnvironmentCoupling.get(name);
    }

    @Override
    public void rollback() {
        try {
            this.connection.rollback();
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public void close() {
        if (this.connection != null) {
            Connection temp = this.connection;
            this.connection = null;
            try {
                temp.close();
            }
            catch (SQLException e) {
                LOGGER.warn("On close connection", (Object)temp);
            }
        }
    }

    @Override
    public void handleNotFound() {
    }

    @Override
    public void handleEmpty() {
    }

    @Override
    public void handleOk(Object object) {
    }
}

