/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.definition;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import net.sf.aguacate.definition.ExecutionListener;
import net.sf.aguacate.definition.FunctionContextDefinition;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.config.database.DatabaseCoupling;
import net.sf.aguacate.util.type.Fld;
import net.sf.aguacate.util.type.Fun;
import net.sf.aguacate.validator.ValidationConversionResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Definition {
    private static final Logger LOGGER = LogManager.getLogger(Definition.class);
    private final String datasource;
    private final Field[] fields;
    private final Function[] validators;
    private final Function[] processors;

    public Definition(String datasource, Collection<Field> fields, Collection<Function> validators, Collection<Function> processors) {
        this(datasource, Fld.toArray(fields), Fun.toArray(validators), Fun.toArray(processors));
    }

    public Definition(String datasource, Field[] fields, Function[] validators, Function[] processors) {
        this.datasource = datasource;
        this.fields = fields;
        this.validators = validators;
        this.processors = processors;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Map<String, Object> input, ExecutionListener listener) {
        int i;
        LinkedHashMap<String, Object> context = new LinkedHashMap<String, Object>();
        int length = this.fields.length;
        for (i = 0; i < length; ++i) {
            Field field = this.fields[i];
            String name = field.getName();
            Object value = input.get(name);
            if (value == null) {
                if (field.isOptional()) {
                    LOGGER.trace("Ignore {}: null & optional", (Object)name);
                    continue;
                }
                LOGGER.warn("Failure {}: null & not optional", (Object)name);
                listener.missingParameter(name);
                break;
            }
            ValidationConversionResult vAndC = field.validateAndConvert(value);
            if (vAndC.isSuccess()) {
                Object val = vAndC.getValue();
                LOGGER.debug("Successful validation & conversion of {}", (Object)name);
                context.put(name, val);
                continue;
            }
            listener.validationConversion(name, vAndC.getMessage());
            LOGGER.warn("Failure validating or converting:: {}", (Object)name);
            break;
        }
        if (i == length) {
            FunctionContextDefinition functionContext = new FunctionContextDefinition(DatabaseCoupling.getDatabaseBridge(this.datasource));
            try {
                FunctionEvalResult result = this.execute(this.validators, functionContext, context);
                if (result == null || result.isSuccess()) {
                    LOGGER.info("validations: OK");
                    result = this.execute(this.processors, functionContext, context);
                    if (result == null || result.isSuccess()) {
                        LOGGER.info("processors: OK");
                        listener.success();
                    } else {
                        LOGGER.warn("processors: FAIL");
                        functionContext.rollback();
                        listener.error(result.getMessage());
                    }
                } else {
                    LOGGER.warn("validations: FAIL");
                    listener.error(result.getMessage());
                }
            }
            catch (RuntimeException e) {
                LOGGER.warn("validations: EXCEPTION", (Throwable)e);
                functionContext.rollback();
                listener.exception(e.getMessage());
            }
            finally {
                try {
                    functionContext.close();
                }
                catch (IOException e) {
                    LOGGER.warn("On close resource", (Throwable)e);
                }
            }
        }
    }

    FunctionEvalResult execute(Function[] functions, FunctionContext functionContext, Map<String, Object> context) {
        for (Function function : functions) {
            FunctionEvalResult result;
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Execution of: {}", (Object)function.getName());
            }
            if ((result = function.evaluate(functionContext, context)).isSuccess()) {
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info("Success execution of: {}", (Object)function.getName());
                }
            } else {
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("UnSuccess execution of: {}", (Object)function.getName());
                }
                return result;
            }
            this.saveValue(function, result.getData(), context);
        }
        return null;
    }

    void saveValue(Function function, Object value, Map<String, Object> context) {
        String outputName = function.getOutputName();
        if (outputName == null) {
            if (LOGGER.isWarnEnabled()) {
                LOGGER.warn("Unsaved value for function: {}", (Object)function.getName());
            }
        } else {
            String[] outputContext = function.getOutputContext();
            if (outputContext == null || outputContext.length == 0) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Save {}: {}", (Object)function.getName(), (Object)outputName);
                }
                context.put((String)outputName, (Object)value);
            } else {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Save {}: {} & {}", (Object)function.getName(), (Object)outputName, Arrays.asList(outputContext));
                }
                Map ctx = context;
                for (String name : outputContext) {
                    ctx = (Map)ctx.get(name);
                }
                ctx.put((String)outputName, (Object)value);
            }
        }
    }
}

