/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.context.spi.sql.impl;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import net.sf.aguacate.context.spi.sql.impl.AbstractSentenceSql;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.parameter.Prm;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SentenceSqlUpdate
extends AbstractSentenceSql {
    private static final Logger LOGGER = LogManager.getLogger(SentenceSqlUpdate.class);
    private final String table;
    private final Parameter[] required;
    private final Parameter[] optional;

    public SentenceSqlUpdate(String name, String message, String table, List<String> methods, List<Parameter> required, List<Parameter> optional) {
        super(name, message, methods);
        this.table = table;
        this.required = Prm.toArray(required);
        this.optional = Prm.toArray(optional);
    }

    @Override
    public FunctionEvalResult evaluate0(FunctionContext functionContext, Map<String, Object> context) throws SQLException {
        int count = functionContext.databaseInterface().executeUpdate(functionContext.acquireConnection(), this.table, context, this.required, this.optional);
        if (LOGGER.isInfoEnabled()) {
            LOGGER.debug("update: {}", (Object)count);
        }
        if (count == 1) {
            return SUCCESS;
        }
        return FAILURE;
    }
}

