/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.context.impl;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.sf.aguacate.context.ContextValidationResult;
import net.sf.aguacate.context.ContextValidator;
import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ContextValidatorSql
implements ContextValidator {
    private static final Logger LOGGER = LogManager.getLogger(ContextValidatorSql.class);
    private final Function[] functions;

    public ContextValidatorSql(Collection<Function> functions) {
        this.functions = functions.toArray(new Function[functions.size()]);
    }

    @Override
    public ContextValidationResult validate(FunctionContext functionContext, String method, Map<String, Object> context) {
        for (Function function : this.functions) {
            String name = function.getName();
            if (function.validFor(method)) {
                LOGGER.trace("execution {}", (Object)name);
                FunctionEvalResult result = function.evaluate(functionContext, context);
                boolean success = result.isSuccess();
                LOGGER.debug("execution {}: {}", (Object)name, (Object)success);
                if (success) {
                    String outputName = function.getOutputName();
                    LOGGER.trace(outputName);
                    if (outputName != null) {
                        String[] outputContext = function.getOutputContext();
                        if (outputContext != null && outputContext.length > 0) {
                            Map ctx = context;
                            for (String ctxName : outputContext) {
                                Map temp;
                                ctx = temp = (Map)ctx.get(ctxName);
                            }
                            LOGGER.trace("working ctx: {}", ctx);
                            ctx.put((String)outputName, (Object)result.getData());
                        } else {
                            context.put((String)outputName, (Object)result.getData());
                        }
                    }
                    LOGGER.trace("new context: {}", context);
                    continue;
                }
                return new ContextValidationResult(Collections.singletonList(result), null);
            }
            LOGGER.info("avoid execution: {}", (Object)name);
        }
        return new ContextValidationResult(null, context);
    }
}

