/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.configuration.impl;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.sf.aguacate.configuration.Configuration;
import net.sf.aguacate.context.ContextProcessor;
import net.sf.aguacate.context.ContextValidator;
import net.sf.aguacate.field.Field;
import net.sf.aguacate.field.format.FieldFormat;
import net.sf.aguacate.util.type.Str;
import net.sf.aguacate.validator.InputValidator;
import net.sf.aguacate.validator.impl.InputValidatorImpl;

public class ConfigurationImpl
implements Configuration {
    private final String datasource;
    private final Map<String, InputValidator> validatorConverters;
    private final Map<String, Map<String, FieldFormat>> outputFields;
    private final ContextValidator contextValidator;
    private final ContextProcessor contextProcessor;
    private final String[] methods;

    public ConfigurationImpl(String primary, String datasource, Map<String, Map<String, Field>> inputFields, Map<String, Map<String, FieldFormat>> outputFields, ContextValidator contextValidator, ContextProcessor contextProcessor) {
        HashMap<String, InputValidator> temp = new HashMap<String, InputValidator>();
        for (Map.Entry<String, Map<String, Field>> entry : inputFields.entrySet()) {
            Map<String, Field> fields = entry.getValue();
            temp.put(entry.getKey(), new InputValidatorImpl(fields.remove(primary), fields));
        }
        this.datasource = datasource;
        this.validatorConverters = temp;
        this.outputFields = outputFields;
        this.contextValidator = contextValidator;
        this.contextProcessor = contextProcessor;
        Set<String> methods1 = this.validatorConverters.keySet();
        Set<String> methods2 = outputFields.keySet();
        if (methods1 == null) {
            this.methods = methods2 == null ? new String[0] : Str.toArray(methods2);
        } else if (methods2 == null) {
            this.methods = Str.toArray(methods1);
        } else {
            TreeSet<String> set = new TreeSet<String>(methods1);
            set.addAll(methods2);
            this.methods = Str.toArray(set);
        }
        Arrays.sort(this.methods);
    }

    @Override
    public String getDatasource() {
        return this.datasource;
    }

    @Override
    public InputValidator getValidatorConverter(String method) {
        return this.validatorConverters.get(method);
    }

    @Override
    public boolean accepts(String method) {
        return Arrays.binarySearch(this.methods, method) >= 0;
    }

    @Override
    public Map<String, FieldFormat> getOutputFields(String method) {
        return this.outputFields.get(method);
    }

    @Override
    public ContextValidator getContextValidator() {
        return this.contextValidator;
    }

    @Override
    public ContextProcessor getContextProcessor() {
        return this.contextProcessor;
    }

    @Override
    public String[] methods() {
        return this.methods;
    }
}

