/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.cloud.storage.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.sf.aguacate.cloud.storage.StorageBridge;
import net.sf.aguacate.cloud.storage.StorageBridgeBuilder;
import net.sf.aguacate.cloud.storage.StorageBridgeLoader;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageBridgeLoaderSpi
implements StorageBridgeLoader,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(StorageBridgeLoaderSpi.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.file.storage");
    private static final String ENVIRONMENT = "STORAGE_FILE";
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private static final Map<String, StorageBridgeBuilder> builders;
    private Map<String, StorageBridge> bridges;
    private final ResourceLocator locator;

    public StorageBridgeLoaderSpi() {
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(StorageBridge.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
        this.bridges = new HashMap<String, StorageBridge>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StorageBridge getStorageBridge(String name) {
        StorageBridge bridge = this.bridges.get(name);
        if (bridge == null) {
            StorageBridgeLoaderSpi storageBridgeLoaderSpi = this;
            synchronized (storageBridgeLoaderSpi) {
                bridge = this.bridges.get(name);
                if (bridge == null) {
                    bridge = this.load0(name.concat(SUFFIX));
                    HashMap<String, StorageBridge> temp = new HashMap<String, StorageBridge>(this.bridges);
                    temp.put(name, bridge);
                    this.bridges = temp;
                }
            }
        }
        return bridge;
    }

    public StorageBridge load0(String file) {
        LOGGER.debug("trying to load {}", (Object)file);
        LOGGER2.info("Loading database: {}", (Object)file);
        try {
            Map<String, Object> configuration = this.checkSpecs(this.readConfiguration(file));
            return builders.get(((Map)configuration.get("specs")).get("impl")).build(configuration);
        }
        catch (IOException e) {
            LOGGER.error("on opening resource", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        for (String key : SPECS.keySet()) {
            if (SPECS.get(key).equals(specs.get(key))) continue;
            throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode(specs)));
        }
        return data;
    }

    Map<String, Object> readConfiguration(String file) throws IOException {
        InputStream inputStream = this.locator.open(file);
        if (inputStream == null) {
            LOGGER.warn("no configuration for {}", (Object)file);
            throw new UnsupportedOperationException();
        }
        try {
            Map<String, Object> map = CodecCoupling.jsonCodecBridge().decodeMap(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("on closing resource", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing database definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            StorageBridgeLoaderSpi storageBridgeLoaderSpi = this;
            synchronized (storageBridgeLoaderSpi) {
                if (this.bridges.containsKey(name)) {
                    HashMap<String, StorageBridge> temp = new HashMap<String, StorageBridge>(this.bridges);
                    temp.remove(name);
                    this.bridges = temp;
                    LOGGER.info("deleted: {} & {}", (Object)directory, (Object)deleted);
                } else {
                    LOGGER.info("Not loaded: {} & {}", (Object)directory, (Object)deleted);
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {} & {}", (Object)directory, (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on database: {}", (Object)updated);
            String name = this.removeSufix(file);
            StorageBridgeLoaderSpi storageBridgeLoaderSpi = this;
            synchronized (storageBridgeLoaderSpi) {
                if (this.bridges.containsKey(name)) {
                    HashMap<String, StorageBridge> temp = new HashMap<String, StorageBridge>(this.bridges);
                    temp.put(name, this.load0(file));
                    this.bridges = temp;
                    LOGGER.info("loaded: {} & {}", (Object)directory, (Object)updated);
                } else {
                    LOGGER.info("not loaded until required: {} & {}", (Object)directory, (Object)updated);
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {} & {}", (Object)directory, (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No STORAGE_FILE defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using STORAGE_FILE (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using STORAGE_FILE (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("kind", "storage");
        spec.put("format", "1.0");
        SPECS = spec;
        builders = new HashMap<String, StorageBridgeBuilder>();
        for (StorageBridgeBuilder current : ServiceLoader.load(StorageBridgeBuilder.class)) {
            builders.put(current.getProvider(), current);
        }
    }
}

