/*
 * Decompiled with CFR 0.152.
 */
package net.sf.aguacate.cloud.messaging.spi;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import net.sf.aguacate.cloud.messaging.MessagingBridge;
import net.sf.aguacate.cloud.messaging.MessagingBridgeBuilder;
import net.sf.aguacate.cloud.messaging.MessagingBridgeLoader;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.filesystem.EventHandler;
import net.sf.aguacate.util.filesystem.FileSystemObserver;
import net.sf.aguacate.util.resource.ResourceLocator;
import net.sf.aguacate.util.resource.impl.ResourceLocatorClassImpl;
import net.sf.aguacate.util.resource.impl.ResourceLocatorFileImpl;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MessagingBridgeLoaderSpi
implements MessagingBridgeLoader,
EventHandler {
    private static final Logger LOGGER = LogManager.getLogger(MessagingBridgeLoaderSpi.class);
    private static final Logger LOGGER2 = LogManager.getLogger((String)"aguacate.messaging");
    private static final String ENVIRONMENT = "MESSAGING";
    private static final String SUFFIX = ".json";
    private static final int SUFFIX_LENGTH = 5;
    private static final File DIRECTORY;
    private static final Map<String, Object> SPECS;
    private static final Map<String, MessagingBridgeBuilder> builders;
    private Map<String, MessagingBridge> bridges;
    private final ResourceLocator locator;

    public MessagingBridgeLoaderSpi() {
        if (DIRECTORY == null) {
            this.locator = new ResourceLocatorClassImpl(MessagingBridge.class);
        } else {
            this.locator = new ResourceLocatorFileImpl(DIRECTORY);
            FileSystemObserver.watch(DIRECTORY.toPath(), this);
        }
        this.bridges = new HashMap<String, MessagingBridge>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public MessagingBridge getMessagingBridge(String name) {
        MessagingBridge bridge = this.bridges.get(name);
        if (bridge == null) {
            MessagingBridgeLoaderSpi messagingBridgeLoaderSpi = this;
            synchronized (messagingBridgeLoaderSpi) {
                bridge = this.bridges.get(name);
                if (bridge == null) {
                    bridge = this.load0(name.concat(SUFFIX));
                    HashMap<String, MessagingBridge> temp = new HashMap<String, MessagingBridge>(this.bridges);
                    temp.put(name, bridge);
                    this.bridges = temp;
                }
            }
        }
        return bridge;
    }

    public MessagingBridge load0(String file) {
        LOGGER.debug("trying to load {}", (Object)file);
        LOGGER2.info("Loading database: {}", (Object)file);
        try {
            Map<String, Object> configuration = this.checkSpecs(this.readConfiguration(file));
            return builders.get(((Map)configuration.get("specs")).get("impl")).build(configuration);
        }
        catch (IOException e) {
            LOGGER.error("on opening resource", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    Map<String, Object> checkSpecs(Map<String, Object> data) {
        Map specs = (Map)data.get("specs");
        if (specs == null) {
            throw new IllegalArgumentException("no specs");
        }
        for (String key : SPECS.keySet()) {
            if (SPECS.get(key).equals(specs.get(key))) continue;
            throw new IllegalArgumentException("unsupported specs: ".concat(CodecCoupling.jsonCodecBridge().encode(specs)));
        }
        return data;
    }

    Map<String, Object> readConfiguration(String file) throws IOException {
        InputStream inputStream = this.locator.open(file);
        if (inputStream == null) {
            LOGGER.warn("no configuration for {}", (Object)file);
            throw new UnsupportedOperationException();
        }
        try {
            Map<String, Object> map = CodecCoupling.jsonCodecBridge().decodeMap(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
            return map;
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException e) {
                LOGGER.error("on closing resource", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDelete(Path directory, Path deleted) {
        String file = deleted.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.warn("Removing database definition: {}", (Object)deleted);
            String name = this.removeSufix(file);
            MessagingBridgeLoaderSpi messagingBridgeLoaderSpi = this;
            synchronized (messagingBridgeLoaderSpi) {
                if (this.bridges.containsKey(name)) {
                    HashMap<String, MessagingBridge> temp = new HashMap<String, MessagingBridge>(this.bridges);
                    temp.remove(name);
                    this.bridges = temp;
                    LOGGER.info("deleted: {} & {}", (Object)directory, (Object)deleted);
                } else {
                    LOGGER.info("Not loaded: {} & {}", (Object)directory, (Object)deleted);
                }
            }
        } else {
            LOGGER.debug("ignore deleted file: {} & {}", (Object)directory, (Object)deleted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onUpdate(Path directory, Path updated) {
        String file = updated.toString();
        if (file.endsWith(SUFFIX)) {
            LOGGER2.info("Change detected on database: {}", (Object)updated);
            String name = this.removeSufix(file);
            MessagingBridgeLoaderSpi messagingBridgeLoaderSpi = this;
            synchronized (messagingBridgeLoaderSpi) {
                if (this.bridges.containsKey(name)) {
                    HashMap<String, MessagingBridge> temp = new HashMap<String, MessagingBridge>(this.bridges);
                    temp.put(name, this.load0(file));
                    this.bridges = temp;
                    LOGGER.info("loaded: {} & {}", (Object)directory, (Object)updated);
                } else {
                    LOGGER.info("not loaded until required: {} & {}", (Object)directory, (Object)updated);
                }
            }
        } else {
            LOGGER2.warn("Ignored : {}", (Object)updated);
            LOGGER.debug("ignore updated file: {} & {}", (Object)directory, (Object)updated);
        }
    }

    String removeSufix(String name) {
        return name.substring(0, name.length() - 5);
    }

    static {
        assert (5 == SUFFIX.length());
        String temp = System.getProperty(ENVIRONMENT);
        if (temp == null || temp.isEmpty()) {
            temp = System.getenv(ENVIRONMENT);
            if (temp == null || temp.isEmpty()) {
                LOGGER.info("No MESSAGING defined, using default");
                DIRECTORY = null;
            } else {
                LOGGER.info("using MESSAGING (env): {}", (Object)temp);
                DIRECTORY = new File(temp);
            }
        } else {
            LOGGER.info("using MESSAGING (prop): {}", (Object)temp);
            DIRECTORY = new File(temp);
        }
        HashMap<String, Object> spec = new HashMap<String, Object>();
        spec.put("kind", "messaging");
        spec.put("format", "1.0");
        SPECS = spec;
        builders = new HashMap<String, MessagingBridgeBuilder>();
        for (MessagingBridgeBuilder current : ServiceLoader.load(MessagingBridgeBuilder.class)) {
            builders.put(current.getProvider(), current);
        }
    }
}

