package net.sf.aguacate.validator;

import java.util.Map;

public class InputValidationResponse {

	private final Map<String, Object> context;

	private final Map<String, ValidationConversionResult> failures;

	public InputValidationResponse(Map<String, Object> context, Map<String, ValidationConversionResult> failures) {
		this.context = context;
		this.failures = failures;
	}

	public boolean isSuccess() {
		return failures == null || failures.isEmpty();
	}

	public Map<String, Object> getContext() {
		return context;
	}

	public Map<String, ValidationConversionResult> getFailures() {
		return failures;
	}

}
