package net.sf.aguacate.util.type;

import java.math.BigInteger;

public final class Int {

	private Int() {
	}

	public static BigInteger parse(Object value) {
		if (value instanceof String) {
			return new BigInteger((String) value);
		} else {
			if (value instanceof Integer || value instanceof Long) {
				return BigInteger.valueOf(((Number) value).longValue());
			} else {
				throw new IllegalArgumentException(value.getClass().getName());
			}
		}
	}

	public static BigInteger parsePositive(String value) {
		if (value == null) {
			return null;
		} else {
			int length = value.length();
			long sum = 0;
			final long limit1 = Long.MAX_VALUE / 10;
			final long limit2 = Long.MAX_VALUE % 10;
			for (int i = 0; i < length; i++) {
				if (sum > limit1) {
					// overflow
					return null;
				} else {
					char c = value.charAt(i);
					if (c < '0' || c > '9') {
						return null;
					} else {
						int digit = c - '0';
						if (sum == limit1 && digit > limit2) {
							return null;
						} else {
							sum = (sum * 10) + digit;
						}
					}
				}
			}
			return BigInteger.valueOf(sum);
		}
	}

}
