package net.sf.aguacate.util.parameter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.util.type.Str;

public final class Prm {

	private static final Parameter[] EMPTY = new Parameter[0];

	private Prm() {
	}

	static List<Parameter> toList0(List<?> original, int shift) {
		int size = original.size();
		List<Parameter> result = new ArrayList<>(size - shift);
		for (int i = shift; i < size; i++) {
			result.add(toParameter(original.get(i)));
		}
		return result;
	}

	public static List<Parameter> toList(List<?> original, int shift) {
		if (original == null) {
			return Collections.emptyList();
		} else {
			return toList0(original, shift);
		}
	}

	static List<Parameter> toList0(List<?> original) {
		return toList0(original, 0);
	}

	public static List<Parameter> toList(List<?> original) {
		if (original == null) {
			return Collections.emptyList();
		} else {
			return toList0(original);
		}
	}

	public static List<Parameter> toList(Object object) {
		if (object == null) {
			return Collections.emptyList();
		} else {
			if (object instanceof List) {
				return toList0((List<?>) object);
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return Collections.singletonList(toParameter(object));
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

	public static Parameter[] toArray(Collection<Parameter> list) {
		if (list == null || list.isEmpty()) {
			return EMPTY;
		} else {
			return list.toArray(new Parameter[list.size()]);
		}
	}

	@SuppressWarnings("unchecked")
	public static Parameter toParameter(Object object) {
		if (object == null) {
			return null;
		} else {
			if (object instanceof Map) {
				Map<String, Object> map = (Map<String, Object>) object;
				return new Parameter(Str.toList(map.get("context")), (String) map.get("name"),
						(String) map.get("aliasOf"), (String) map.get("from"));
			} else {
				Class<?> klass = object.getClass();
				if (String.class == klass) {
					return new Parameter((String) object);
				} else {
					throw new IllegalStateException(klass.getName());
				}
			}
		}
	}

}
