package net.sf.aguacate.util.meta.maven;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Properties;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.meta.Meta;
import net.sf.aguacate.util.meta.MetaBuilder;

public class MetaBuilderMaven implements MetaBuilder {

	private static final Logger LOGGER = LogManager.getLogger(MetaBuilderMaven.class);

	private static final String BASE = "/META-INF/maven/";

	@Override
	public Meta build(Class<?> klass, String group, String artifact) {
		String name = BASE + group + '/' + artifact + '/' + "pom.properties";
		LOGGER.debug(name);
		InputStream inputStream = klass.getResourceAsStream(name);
		if (inputStream == null) {
			return null;
		} else {
			try {
				Properties properties = new Properties();
				properties.load(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
				String version = properties.getProperty("version");
				LOGGER.debug("version ({} & {}): {}", group, artifact, version);
				return new MetaMaven(version);
			} catch (IOException e) {
				throw new IllegalStateException(e);
			} finally {
				try {
					inputStream.close();
				} catch (IOException e) {
					LOGGER.warn("On close inputStream", e);
				}
			}
		}
	}

}
