package net.sf.aguacate.util.filesystem;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.util.filesystem.spi.WatchdogRunner;

public final class FileSystemObserver {

	private static final Logger LOGGER = LogManager.getLogger(FileSystemObserver.class);

	private static Collection<WatchdogRunner> runners;

	private static ThreadGroup group;

	static {
		runners = Collections.emptyList();
		group = new ThreadGroup("observer");
	}

	private FileSystemObserver() {
	}

	public static void watch(Path directory, EventHandler handler) {
		WatchdogRunner runner = new WatchdogRunner(directory, handler);
		String name;
		synchronized (FileSystemObserver.class) {
			LOGGER.info("{} handled by {}", directory, handler);
			Collection<WatchdogRunner> temp = new ArrayList<>(runners);
			temp.add(runner);
			int size = temp.size();
			StringBuilder builder = new StringBuilder(group.getName());
			builder.append('-');
			if (size < 100) {
				builder.append('0');
				if (size < 10) {
					builder.append('0');
				}
			}
			builder.append(size);
			builder.append('-');
			builder.append(directory.getFileName());
			name = builder.toString();
			LOGGER.trace("{}: {}", name, temp);
			runners = temp;
		}
		new Thread(group, runner, name).start();
	}

}
