package net.sf.aguacate.util.config.database;

import java.math.BigInteger;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.util.parameter.Parameter;

public interface DatabaseInterface {

	String getVendor();

	Map<String, Object> executeSqlSelectSingleRow(String name, String message, Connection connection, String sql,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	List<Map<String, Object>> executeSqlSelectMultipleRow(String name, String message, Connection connection,
			String sql, Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	Object executeSqlSelectValue(String name, String message, Connection connection, String sql,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	List<Object> executeSqlSelectList(String name, String message, Connection connection, String sql,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	int executeSqlUpdate(Connection connection, String sql, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	int executeSqlInsert(Connection connection, String sql, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	int executeSqlDelete(Connection connection, String sql, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	BigInteger executeSqlInsertWithId(Connection connection, String sql, Map<String, Object> context,
			Parameter[] required, Parameter[] optional, String[] keys) throws SQLException;

	Map<String, Object> executeSelectSingleRow(String name, String message, Connection connection, String table,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	List<Map<String, Object>> executeSelectMultipleRow(String name, String message, Connection connection, String table,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	Object executeSelectValue(String name, String message, Connection connection, String table,
			Map<String, Object> context, Parameter[] required, Parameter[] optional) throws SQLException;

	int executeUpdate(Connection connection, String table, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	int executeInsert(Connection connection, String table, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	int executeDelete(Connection connection, String table, Map<String, Object> context, Parameter[] required,
			Parameter[] optional) throws SQLException;

	BigInteger executeInsertWithId(Connection connection, String table, Map<String, Object> context,
			Parameter[] required, Parameter[] optional, String[] keys) throws SQLException;

}
