package net.sf.aguacate.regex.spi.script;

import javax.script.Compilable;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.regex.Regex;
import net.sf.aguacate.regex.spi.RegexFactory;

public class RegexFactoryScriptEngineJs implements RegexFactory {

	private static final Logger LOGGER = LogManager.getLogger(RegexFactoryScriptEngineJs.class);

	private final Invocable invocable;

	private final Compilable compilable;

	private final ScriptEngine engine;

	public RegexFactoryScriptEngineJs() {
		engine = new ScriptEngineManager().getEngineByName("javascript");
		invocable = (Invocable) engine;
		compilable = (Compilable) engine;
	}

	@Override
	public Regex build(String regex) {
		String script = '/' + regex.replace("/", "\\/") + '/';
		LOGGER.debug(script);
		try {
			return new RegexScriptEngineJs(invocable, compilable.compile(script));
		} catch (ScriptException e) {
			throw new IllegalStateException(e);
		}
	}

}
