package net.sf.aguacate.function.spi.impl;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Collection;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction1;
import net.sf.aguacate.util.parameter.Parameter;

public class FunctionZero extends AbstractFunction1 {

	public FunctionZero(Collection<String> methods, String name, String message, Parameter parameter) {
		super(methods, name, message, parameter);
	}

	@Override
	protected FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value) {
		Class<? extends Object> klass = value.getClass();
		if (BigInteger.class == klass) {
			if (BigInteger.ZERO.equals(value)) {
				logSuccess(msg);
				return new FunctionEvalResult(null, null);
			} else {
				logFailure(msg);
				return new FunctionEvalResult("Not Zero", null);
			}
		} else {
			if (Long.class == klass) {
				if (Long.valueOf(0).equals(value)) {
					logSuccess(msg);
					return new FunctionEvalResult(null, null);
				} else {
					logFailure(msg);
					return new FunctionEvalResult("Not Zero", null);
				}
			} else {
				if (BigDecimal.class == klass) {
					BigDecimal val = (BigDecimal) value;
					BigDecimal zero = BigDecimal.ZERO.setScale(val.scale());
					if (zero.equals(val)) {
						logSuccess(msg);
						return new FunctionEvalResult(null, null);
					} else {
						logFailure(msg);
						return new FunctionEvalResult("Not Zero", null);
					}
				} else {
					logFailure(msg);
					return new FunctionEvalResult("Not implemented", null);
				}
			}
		}
	}

}
