package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunctionN;
import net.sf.aguacate.script.DynamicCacheCoupling;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionScript extends AbstractFunctionN {

	private static final Logger LOGGER = LogManager.getLogger(FunctionScript.class);

	private final String[] outputContext;

	private final String outputName;

	private String scriptName;

	private String functionName;

	public FunctionScript(Collection<String> methods, String name, String message, List<Parameter> parameters,
			List<String> outputContext, String outputName, String scriptName, String functionName) {
		super(methods, name, message, parameters);
		this.scriptName = scriptName;
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.functionName = functionName;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Object[] values, String msg) {
		Object value = DynamicCacheCoupling.get(scriptName).exec(functionName, values);
		if (value instanceof Map) {
			@SuppressWarnings("unchecked")
			Map<String, Object> map = (Map<String, Object>) value;
			String message = (String) map.get("message");
			Object val = map.get("value");
			if (message == null) {
				if (val == null) {
					logFailure(msg);
					return new FunctionEvalResult("Missing state", null);
				} else {
					logSuccess(msg);
					return new FunctionEvalResult(null, val);
				}
			} else {
				if (val == null) {
					logFailure(msg);
					return new FunctionEvalResult(message, null);
				} else {
					logFailure(msg);
					LOGGER.warn("Invalid state: message = {} & value = {}", message, val);
					return new FunctionEvalResult("Invalid state", null);
				}
			}
		} else {
			logFailure(msg);
			LOGGER.warn("Invalid state: {}", value);
			return new FunctionEvalResult("Invalid state", null);
		}
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
