package net.sf.aguacate.function.spi.impl;

import java.io.IOException;
import java.util.Collection;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction1;
import net.sf.aguacate.util.codec.bridge.CodecCoupling;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionJsonDecode extends AbstractFunction1 {

	private final String[] outputContext;

	private final String outputName;

	public FunctionJsonDecode(Collection<String> methods, String name, String message, Parameter parameter,
			Collection<String> outputContext, String outputName) {
		super(methods, name, message, parameter);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	protected FunctionEvalResult evaluate(FunctionContext functionContext, String msg, Object value) {
		try {
			return new FunctionEvalResult(true, CodecCoupling.jsonCodecBridge().decodeMap((String) value));
		} catch (IOException e) {
			throw new IllegalStateException(e);
		}
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
