package net.sf.aguacate.function.spi.impl;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionCopy extends AbstractFunction {

	private final String message;

	private final String[] outputContext;

	private final String outputName;

	private final Parameter parameter;

	public FunctionCopy(Collection<String> methods, String name, String message, Parameter parameter,
			List<String> outputContext, String outputName) {
		super(methods, name);
		this.message = message;
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.parameter = parameter;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		Map<String, Object> initial;
		String from = parameter.getFrom();
		if (from == null) {
			initial = context;
		} else {
			initial = functionContext.get(from);
		}
		Object value = parameter.calculateContext(initial).get(parameter.getName());
		String msg = MessageFormat.format(message, value);
		logSuccess(msg);
		return new FunctionEvalResult(true, value);
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

}
