package net.sf.aguacate.function.spi.impl;

import java.util.Collection;

import net.sf.aguacate.cloud.storage.StorageCoupling;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction2;
import net.sf.aguacate.util.parameter.Parameter;

public class FunctionCloudStorageSave extends AbstractFunction2 {

	public static final String STORAGE_CLOUD_SAVE = "STORAGE_CLOUD_SAVE";

	private final String storage;

	public FunctionCloudStorageSave(Collection<String> methods, String name, String message, String storage,
			Parameter parameter1, Parameter parameter2) {
		super(methods, name, message, parameter1, parameter2);
		this.storage = storage;
	}

	@Override
	protected FunctionEvalResult evaluate(String msg, Object value1, Object value2) {
		StorageCoupling.getStorageBridge(storage).put((String) value1, (byte[]) value2);
		logSuccess(msg);
		return SUCCESS;
	}

}
