package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;

import net.sf.aguacate.cloud.storage.StorageCoupling;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction2;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

public class FunctionCloudStorageGet extends AbstractFunction2 {

	public static final String STORAGE_CLOUD_GET = "STORAGE_CLOUD_GET";

	private final String outputName;

	private final String[] outputContext;

	public FunctionCloudStorageGet(Collection<String> methods, String name, String message, Parameter parameter1,
			Parameter parameter2, List<String> outputContext, String outputName) {
		super(methods, name, message, parameter1, parameter2);
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
	}

	@Override
	protected FunctionEvalResult evaluate(String msg, Object value1, Object value2) {
		byte[] bytes = StorageCoupling.getStorageBridge((String) value1).get((String) value2);
		if (bytes == null) {
			logSuccess(msg);
			return FAILURE;
		} else {
			logFailure(msg);
			return new FunctionEvalResult(true, bytes);
		}
	}

	@Override
	public String[] getOutputContext() {
		return outputContext;
	}

	@Override
	public String getOutputName() {
		return outputName;
	}

}
