package net.sf.aguacate.function.spi.impl;

import java.util.Collection;
import java.util.List;
import java.util.Map;

import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

import net.sf.aguacate.function.Function;
import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.function.spi.AbstractFunction;
import net.sf.aguacate.util.parameter.Parameter;
import net.sf.aguacate.util.type.Str;

/**
 * <pre>
 * {
 *  "name": "...",
 *  "message": "...",
 *  "type" : "STRUCTURE_ARRAY_ITERATOR",
 *  "parameters" : [
 *   ...
 *  ],
 *  "validations": [
 *   ...
 *  ],
 *  "methods": [
 *   ...
 *  ]
 * }
 * </pre>
 */
public class FunctionArrayIterator extends AbstractFunction {

	private static final Logger LOGGER = LogManager.getLogger(FunctionArrayIterator.class);

	private String message;

	private Parameter parameter;

	private final String[] outputContext;

	private final String outputName;

	private final Function[] functions;

	public FunctionArrayIterator(Collection<String> methods, String name, String message, Parameter parameter,
			List<String> outputContext, String outputName, List<Function> list) {
		super(methods, name);
		this.message = message;
		this.parameter = parameter;
		this.outputContext = Str.toArray(outputContext);
		this.outputName = outputName;
		this.functions = list.toArray(new Function[list.size()]);
	}

	@Override
	@SuppressWarnings("unchecked")
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		Map<String, Object> working = calculateOutputContext(outputContext, context);
		if (working.containsKey(outputName)) {
			return new FunctionEvalResult(false, "Already defined: " + outputName, null);
		} else {
			List<Map<String, Object>> list = (List<Map<String, Object>>) working.get(parameter.getName());
			int size = list.size();
			for (int i = 0; i < size; i++) {
				Map<String, Object> subcontext = list.get(i);
				working.put(outputName, subcontext);
				LOGGER.trace("before context: {}", context);
				for (Function function : functions) {
					FunctionEvalResult result = function.evaluate(functionContext, context);
					if (result.isSuccess()) {
						String outputName = function.getOutputName();
						if (outputName != null) {
							calculateOutputContext(function.getOutputContext(), context).put(outputName,
									result.getData());
						}
					} else {
						logFailure(message);
						return result;
					}
					LOGGER.trace("in subcontext: {}", context);
				}
				working.remove(outputName);
				LOGGER.trace("after subcontext: {}", context);
			}
			logSuccess(message);
			return SUCCESS;
		}
	}

	@SuppressWarnings("unchecked")
	Map<String, Object> calculateOutputContext(String[] names, Map<String, Object> initial) {
		if (names == null || names.length == 0) {
			return initial;
		} else {
			Map<String, Object> ctx = initial;
			for (String name : names) {
				Map<String, Object> temp1 = (Map<String, Object>) ctx.get(name);
				// TODO: check if temp is null
				ctx = temp1;
			}
			return ctx;
		}
	}

}
