package net.sf.aguacate.function.spi;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Map;

import net.sf.aguacate.function.FunctionContext;
import net.sf.aguacate.function.FunctionEvalResult;
import net.sf.aguacate.util.parameter.Parameter;

public abstract class AbstractFunction3 extends AbstractFunction {

	private final Parameter parameter1;

	private final Parameter parameter2;

	private final Parameter parameter3;

	private final String message;

	public AbstractFunction3(Collection<String> methods, String name, String message, Parameter parameter1,
			Parameter parameter2, Parameter parameter3) {
		super(methods, name);
		this.parameter1 = parameter1;
		this.parameter2 = parameter2;
		this.parameter3 = parameter3;
		this.message = message;
	}

	@Override
	public FunctionEvalResult evaluate(FunctionContext functionContext, Map<String, Object> context) {
		Object value1 = parameter1.calculateContext(context).get(parameter1.getName());
		Object value2 = parameter2.calculateContext(context).get(parameter2.getName());
		Object value3 = parameter3.calculateContext(context).get(parameter3.getName());
		String msg = MessageFormat.format(message, value1, value2, value3);
		return evaluate(msg, value1, value2, value3);
	}

	protected abstract FunctionEvalResult evaluate(String msg, Object value1, Object value2, Object value3);

}
