package net.sf.aguacate.field;

import net.sf.aguacate.regex.Regex;
import net.sf.aguacate.regex.RegexCouplig;
import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldString extends Field {

	private final int minLenth;

	private final int maxLength;

	private final Regex regex;

	public FieldString(String name, boolean optional, int minLenth, int maxLength, String regex) {
		super(name, Field.STRING, optional);
		this.minLenth = minLenth;
		this.maxLength = maxLength;
		this.regex = RegexCouplig.build(regex);
	}

	public int getMinLenth() {
		return minLenth;
	}

	public int getMaxLength() {
		return maxLength;
	}

	public Regex getRegex() {
		return regex;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		if (value.getClass() == String.class) {
			String val = (String) value;
			int length = val.length();
			if (length < minLenth) {
				return new ValidationConversionResult("Invalid minimum length");
			} else {
				if (length > maxLength) {
					return new ValidationConversionResult("Invalid maximum length");
				} else {
					if (regex.matches(val)) {
						return new ValidationConversionResult(value);
					} else {
						return new ValidationConversionResult("No match pattern");
					}
				}
			}
		} else {
			return new ValidationConversionResult("Invalid value");
		}
	}

}
