package net.sf.aguacate.field;

import java.text.Format;
import java.text.ParseException;
import java.util.Date;

import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldDate extends Field {

	private final Format format;

	private final Date minValue;

	private final Date maxValue;

	public FieldDate(String name, boolean optional, Format format, String minValue, String maxValue) {
		super(name, Field.DATE, optional);
		this.format = format;
		try {
			this.minValue = (Date) format.parseObject(minValue);
			this.maxValue = (Date) format.parseObject(maxValue);
		} catch (ParseException e) {
			throw new IllegalStateException(e);
		}
	}

	public Format getFormat() {
		return format;
	}

	public Date getMinValue() {
		return minValue;
	}

	public Date getMaxValue() {
		return maxValue;
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		if (value.getClass() == String.class) {
			try {
				String string = (String) value;
				Date date = (Date) format.parseObject(string);
				if (date == null) {
					return new ValidationConversionResult("Invalid format");
				} else {
					return FieldTimeUtil.validate(minValue, date, maxValue);
				}
			} catch (ParseException e) {
				return new ValidationConversionResult("Invalid format");
			}
		} else {
			return new ValidationConversionResult("Invalid value");
		}
	}

}
