package net.sf.aguacate.field;

import net.sf.aguacate.validator.ValidationConversionResult;

public class FieldBoolean extends Field {

	public FieldBoolean(String name, boolean optional) {
		super(name, Field.BOOLEAN, optional);
	}

	@Override
	public ValidationConversionResult validateAndConvert(Object value) {
		Class<?> klass = value.getClass();
		if (klass == Boolean.class) {
			return new ValidationConversionResult(value);
		} else {
			if (klass == String.class) {
				String val = ((String) value).toLowerCase();
				if ("true".equals(val)) {
					return new ValidationConversionResult(Boolean.TRUE);
				} else {
					if ("false".equals(val)) {
						return new ValidationConversionResult(Boolean.FALSE);
					} else {
						return new ValidationConversionResult("Invalid boolean value");
					}
				}
			} else {
				return new ValidationConversionResult("Invalid boolean value");
			}
		}
	}

}
